/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.environment;

import com.badlogic.gdx.graphics.Color;
import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import java.util.List;
import technology.rocketjump.undermount.environment.model.SunlightPhase;
import technology.rocketjump.undermount.guice.SunlightCalculatorProvider;

@Singleton
@ProvidedBy(value=SunlightCalculatorProvider.class)
public class SunlightCalculator {
    private final List<SunlightPhase> sunlightPhases;

    public SunlightCalculator(List<SunlightPhase> sunlightPhases) {
        this.sunlightPhases = sunlightPhases;
    }

    public Color getSunlightColor(double gameTimeInHours) {
        SunlightPhase previousPhase = null;
        SunlightPhase nextPhase = null;
        for (SunlightPhase sunlightPhase : this.sunlightPhases) {
            if (sunlightPhase.getTime() < gameTimeInHours) {
                previousPhase = sunlightPhase;
                continue;
            }
            if (!(sunlightPhase.getTime() > gameTimeInHours)) continue;
            nextPhase = sunlightPhase;
            break;
        }
        double phaseLength = nextPhase.getTime() - previousPhase.getTime();
        double timeSincePreviousPhase = gameTimeInHours - previousPhase.getTime();
        double timeToNextPhase = nextPhase.getTime() - gameTimeInHours;
        float previousWeighting = (float)(1.0 - timeSincePreviousPhase / phaseLength);
        float nextPhaseWeighting = (float)(1.0 - timeToNextPhase / phaseLength);
        return new Color(previousPhase.getColor().r * previousWeighting + nextPhase.getColor().r * nextPhaseWeighting, previousPhase.getColor().g * previousWeighting + nextPhase.getColor().g * nextPhaseWeighting, previousPhase.getColor().b * previousWeighting + nextPhase.getColor().b * nextPhaseWeighting, 1.0f);
    }
}

